/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.listener.axis.rm;

import filenet.vw.base.logging.Logger;
import filenet.ws.listener.utils.WSListenerProperties;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.Action;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.MessageID;
import org.apache.axis.message.addressing.RelatesTo;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.sandesha.util.PolicyLoader;
import org.apache.sandesha.ws.rm.RMHeaders;

public class WSRMUtils {
    protected static Logger logger = Logger.getLogger("filenet.ws.listener.axis.rm");
    protected static final String m_className = "WSRMUtils";
    protected static String EOL = System.getProperty("line.separator", "\n");
    static WSListenerProperties gWSListenerProperties = null;

    public static String _get_FILE_DATE() {
        return "$Date:   24 Oct 2008 07:26:30  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.6  $";
    }

    public static void setWSListenerProperties(WSListenerProperties props) {
        String m_method = "setWSListenerProperties";
        if (logger.isFinest()) {
            logger.entering(m_className, m_method);
        }
        gWSListenerProperties = props;
        if (logger.isFinest()) {
            logger.exiting(m_className, m_method);
        }
    }

    public static WSListenerProperties getWSListenerProperties() {
        return gWSListenerProperties;
    }

    public static WSListenerProperties getWSListenerProperties(MessageContext msgContext) {
        WSListenerProperties props = WSRMUtils.getWSListenerPropertiesFromMsgContext(msgContext);
        if (props != null) {
            if (WSRMUtils.getWSListenerProperties() == null) {
                WSRMUtils.setWSListenerProperties(props);
            }
            return props;
        }
        return WSRMUtils.getWSListenerProperties();
    }

    protected static WSListenerProperties getWSListenerPropertiesFromMsgContext(MessageContext msgContext) {
        String m_method = "getWSListenerPropertiesFromMsgContext";
        if (msgContext == null) {
            return null;
        }
        Object req = msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (req == null) {
            return null;
        }
        Class<?> HttpServletRequestClass = null;
        Method HttpServletRequest_getAttributeMethod = null;
        try {
            HttpServletRequestClass = Class.forName("javax.servlet.http.HttpServletRequest");
            if (logger.isFinest()) {
                logger.finest("HttpServletRequest class found.");
            }
            Class[] paramClasses = new Class[]{String.class};
            HttpServletRequest_getAttributeMethod = HttpServletRequestClass.getMethod("getAttribute", paramClasses);
            Object[] params = new Object[]{"P8BPM.wsListenerProperties"};
            WSListenerProperties props = (WSListenerProperties)HttpServletRequest_getAttributeMethod.invoke(req, params);
            return props;
        }
        catch (Exception ex) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "HttpServletRequest class not found.");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String[] retrieveCPInfo(WSListenerProperties props) {
        String m_method = "retrieveCPInfo(WSListenerProperties)";
        if (logger.isFinest()) {
            logger.entering(m_className, m_method);
        }
        try {
            if (props != null) {
                String cpName = props.getStanza();
                String[] ret = new String[]{props.getStanza(), props.getFullPath()};
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "cpName = " + cpName);
                    logger.finest(m_className, m_method, "fullPath = " + props.getFullPath());
                }
                String[] stringArray = ret;
                return stringArray;
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Failed to retrieve cpInfo - WSListenerProperties object is null");
            }
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (logger.isFinest()) {
                logger.exiting(m_className, m_method);
            }
        }
    }

    public static int getRMMessageType(MessageContext msgContext) {
        String m_method = "getRMMessageType";
        if (msgContext == null) {
            return 0;
        }
        Object obj = msgContext.getProperty("MC.P8BPM.RM.MESSAGE.TYPE");
        if (obj != null && obj instanceof Integer) {
            return (Integer)obj;
        }
        int msgType = 0;
        try {
            String relatesToMsgId = null;
            if (msgContext != null) {
                RMHeaders rmHeaders = new RMHeaders();
                rmHeaders.fromSOAPEnvelope(msgContext.getRequestMessage().getSOAPEnvelope());
                AddressingHeaders addressingHeaders = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
                MessageID messageID = addressingHeaders.getMessageID();
                if (addressingHeaders != null) {
                    Action action;
                    RelatesTo relatesTo = null;
                    List relatesToList = addressingHeaders.getRelatesTo();
                    if (relatesToList != null && !relatesToList.isEmpty() && (relatesTo = (RelatesTo)relatesToList.get(0)) != null) {
                        relatesToMsgId = relatesTo.getURI().toString();
                    }
                    if (msgType == 0 && (action = addressingHeaders.getAction()) != null) {
                        String msgTypeString = action.toString();
                        if (msgTypeString != null) {
                            if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequence")) {
                                msgType = 1;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/CreateSequenceResponse")) {
                                msgType = 2;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/TerminateSequence")) {
                                msgType = 6;
                            } else if (msgTypeString.equals("http://schemas.xmlsoap.org/ws/2005/02/rm/SequenceAcknowledgement")) {
                                msgType = 5;
                            }
                        }
                        if (msgType == 0) {
                            msgType = relatesToMsgId != null ? 4 : 3;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            msgType = 0;
        }
        msgContext.setProperty("MC.P8BPM.RM.MESSAGE.TYPE", (Object)new Integer(msgType));
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "RM Message type = " + msgType);
        }
        return msgType;
    }

    public static boolean hasRMHeaders(MessageContext msgContext) {
        String m_method = "hasRMHeaders";
        boolean bRMHeaders = false;
        try {
            if (msgContext.getProperty("MC.P8BPM.RM.HEADER") != null) {
                return true;
            }
            RMHeaders rmHeaders = new RMHeaders();
            rmHeaders.fromSOAPEnvelope(msgContext.getRequestMessage().getSOAPEnvelope());
            if (rmHeaders != null && (rmHeaders.getSequence() != null || rmHeaders.getAckRequest() != null || rmHeaders.getSequenceAcknowledgement() != null || rmHeaders.getTerminateSequence() != null || rmHeaders.getCreateSequence() != null || rmHeaders.getCreateSequenceResponse() != null)) {
                msgContext.setProperty("MC.P8BPM.RM.HEADER", (Object)rmHeaders);
                bRMHeaders = true;
            }
        }
        catch (Exception ex) {
            bRMHeaders = false;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "Has RMHeaders = " + bRMHeaders);
        }
        logger.exiting(m_className, m_method);
        return bRMHeaders;
    }

    public static boolean isRMSequenceMessage(MessageContext msgContext) {
        int msgType = WSRMUtils.getRMMessageType(msgContext);
        return WSRMUtils.hasRMHeaders(msgContext) && (msgType == 0 || msgType == 1 || msgType == 2 || msgType == 5 || msgType == 6);
    }

    public static boolean isRMMessage(int msgType) {
        return msgType != 0;
    }

    public static long getRMTimeout() {
        return PolicyLoader.getInstance().getInactivityTimeout() * 5L;
    }
}

